<?php

namespace App\Entity\Reports\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Reports\Report;
use App\Entity\Users\UserID;
use App\Models\Reports\RequestDatesModel;

interface ReportsQueryInterface
{
    /**
     * @param RequestDatesModel $requestDatesModel
     * @return FinanceReportDTO[]
     */
    public function getFinanceReportData(RequestDatesModel $requestDatesModel): array;

    public function getSubscriptionsReportData(): array;

    /**
     * @param RequestDatesModel $requestDates
     * @return array
     */
    public function getOrdersReportData(RequestDatesModel $requestDates): array;

    /**
     * @param UserID $userID
     * @param int $year
     * @return YearReportDTO[]
     */
    public function getYearReportDataByUserID(UserID $userID, ?int $year = null): array;

    /**
     * @param UserID $userID
     * @param int $year
     */
    public function getAnnualReportDataByUserID(UserID $userID, int $year): array;

    /**
     * @param PaginationRequest $paginationRequest
     * @return QuarterReportDTO[]
     */
    public function getQuartersReportData(PaginationRequest $paginationRequest): array;

    /**
     * @param Report $report
     * @return QuarterReportRecipientDTO[]
     */
    public function getQuarterReportRecipients(Report $report): array;
}