<?php

namespace App\Entity\Posts;

use App\Entity\Units\UnitID;

interface PostsInterface
{
    /**
     * @param Post $post
     */
    public function add(Post $post): void;

    /**
     * @param Post $post
     */
    public function remove(Post $post): void;

    /**
     * @param PostID $postID
     * @return Post|null
     */
    public function findOnePostById(PostID $postID): ?Post;

    /**
     * @param PostID $postID
     * @param UnitID $unitID
     * @return Post|null
     */
    public function findOneByPostIDAndUnitID(PostID $postID, UnitID $unitID): ?Post;
}