<?php

namespace App\Entity\Permissions;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Uid\Uuid;

/**
 * @ORM\Entity()
 */
class Permission
{
    /** User accounts */
    const USERS_ADMINISTRATION = 'ROLE_USERS_ADMINISTRATION';
    const ACCOUNT_DATA_MANAGEMENT = 'ROLE_ACCOUNT_DATA_MANAGEMENT';
    const VOLUNTEERING_MANAGEMENT = 'ROLE_VOLUNTEERING_MANAGEMENT';
    /** Units */
    const UNIT_ADMINISTRATION = 'ROLE_UNIT_ADMINISTRATION';
    const UNIT_REDACTION = 'ROLE_UNIT_REDACTION';
    /** Payments */
    const PAYMENTS_MANAGEMENT = 'ROLE_PAYMENTS_MANAGEMENT';
    const HEART_ADOPTION_PAYMENT = 'ROLE_HEART_ADOPTION_PAYMENT';
    /** Access */
    const PRIVATE_ACCESS = 'ROLE_PRIVATE_ACCESS';
    const PUBLIC_ACCESS = 'ROLE_PUBLIC_ACCESS';

    const EDITOR_PERMISSIONS = [
        Permission::UNIT_ADMINISTRATION,
        ...self::USER_PERMISSIONS
    ];
    const USER_PERMISSIONS = [
        Permission::ACCOUNT_DATA_MANAGEMENT,
        Permission::PAYMENTS_MANAGEMENT,
        Permission::HEART_ADOPTION_PAYMENT
    ];

    const VOLUNTEER_PERMISSIONS = [
        Permission::VOLUNTEERING_MANAGEMENT,
        ...self::USER_PERMISSIONS
    ];

    const REDACTOR_PARTNER_PERMISSIONS = [
        Permission::UNIT_REDACTION,
        ...self::USER_PERMISSIONS
    ];

    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private PermissionID|Uuid $uuid;

    /**
     * @ORM\Column(type="string", unique=true)
     */
    private string $name;

    /**
     * @ORM\Column(type="string", unique=true)
     */
    private string $authorization;

    public function __construct(string $name, string $authorization)
    {
        $this->uuid = PermissionID::generate();
        $this->name = $name;
        $this->authorization = $authorization;
    }

    /**
     * @return PermissionID
     */
    public function getUuid(): PermissionID
    {
        return PermissionID::fromString($this->uuid);
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getAuthorization(): string
    {
        return $this->authorization;
    }
}