<?php

namespace App\Entity\Orders\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Subscriptions\Helper\KindOfSubscription;
use App\Entity\Subscriptions\SubscriptionID;

class PaymentSubscriptionDTO
{
    use FromArray;

    private function __construct(
        private string $subscriptionId,
        private string $dateStart,
        private string $unitTitle,
        private string $unitType,
        private int $children,
        private int $monthlyCost,
        private string $kindOfSubscription,
        private ?string $dateEnd = null
    )
    {
        $this->kindOfSubscription = new KindOfSubscription($this->kindOfSubscription);
        $this->subscriptionId = (string)SubscriptionID::fromString($this->subscriptionId);
    }

    /**
     * @return string
     */
    public function getSubscriptionId(): string
    {
        return $this->subscriptionId;
    }

    /**
     * @return string
     */
    public function getDateStart(): string
    {
        return $this->dateStart;
    }

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return string
     */
    public function getUnitType(): string
    {
        return $this->unitType;
    }

    /**
     * @return int
     */
    public function getChildren(): int
    {
        return $this->children;
    }

    /**
     * @return float
     */
    public function getMonthlyCost(): float
    {
        return Money::toRational($this->monthlyCost);
    }

    /**
     * @return string|null
     */
    public function getDateEnd(): ?string
    {
        return $this->dateEnd;
    }

    /**
     * @return string
     */
    public function getKindOfSubscription(): string
    {
        return $this->kindOfSubscription;
    }
}