<?php

namespace App\Entity\Orders\Helper;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Embeddable()
 */
class RenewInformation
{
    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $children;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $months;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private ?int $monthlyCost;

    public function __construct(
        ?int $children = null,
        ?int $months = null,
        ?int $monthlyCost = null
    )
    {
        $this->children = $children;
        $this->months = $months;
        $this->monthlyCost = $monthlyCost;
    }

    /**
     * @return int|null
     */
    public function getChildren(): ?int
    {
        return $this->children;
    }

    /**
     * @return int|null
     */
    public function getMonths(): ?int
    {
        return $this->months;
    }

    /**
     * @return int|null
     */
    public function getMonthlyCost(): ?int
    {
        return $this->monthlyCost;
    }
}