<?php

namespace App\Entity\Orders\Classes;

use App\Entity\Orders\Order;
use App\Entity\Subscriptions\Subscription;
use App\Entity\Units\Unit;
use App\Entity\Users\User;

interface OrderManagerInterface
{
    public function createPurposeOrder(string $email, int $amount, Unit $unit, ?User $user): Order;

    public function createCyclicSubscriptionOrder(int $children, Unit $unit, User $user): Order;

    public function createOneTimeSubscriptionOrder(int $children, Unit $unit, User $user, int $months): Order;

    public function createRenewSubscriptionOrder(Subscription $subscription, int $months, int $monthlyCost): Order;

    public function subscriptionCharge(Subscription $subscription): Order;

    public function orderVerified(Order $order, string $externalID, string $transactionNumber): Order;

    public function renewSubscription(Order $order): Order;
}