<?php

namespace App\Entity\Orders\Classes;

use App\Core\UrlGenerator\Orders\OrderUrlGenerator;
use App\Entity\Orders\Order;
use App\Entity\Orders\OrderID;
use App\Entity\Subscriptions\Subscription;
use App\Entity\Units\Unit;
use App\Entity\Users\User;

class OrderBuilder
{
    //TODO REMOVE CLASS AFTER REVIEW
    private $order;

    public function __construct()
    {
        $this->create();
    }


    public function create(): OrderBuilderInterface
    {
//        $this->order = new Order();
//
//        $this->setUuid(OrderID::generate());
//        $this->setUrlReturn();
//        $this->setUrlWebhook();
//
//        return $this;
    }

    public function update(Order $order): OrderBuilderInterface
    {
        $this->order = $order;
        return $this;
    }

    public function setUuid(OrderID $orderID): OrderBuilderInterface
    {
        $this->order->uuid = $orderID;

        return $this;
    }


    /**
     * @param User|null $user
     * @return OrderBuilderInterface
     */
    public function setUser(?User $user): OrderBuilderInterface
    {
        $this->order->user = $user;
        return $this;
    }

    /**
     * @param Unit $unit
     * @return OrderBuilderInterface
     */
    public function setUnit(Unit $unit): OrderBuilderInterface
    {
        $this->order->unit = $unit;
        return $this;
    }


    /**
     * @param Subscription|null $subscription
     * @return OrderBuilderInterface
     */
    public function setSubscription(?Subscription $subscription): OrderBuilderInterface
    {
        $this->order->subscription = $subscription;
        return $this;
    }

    /**
     * @param string $email
     * @return OrderBuilderInterface
     */
    public function setEmail(string $email): OrderBuilderInterface
    {
        $this->order->email = $email;
        return $this;
    }

    /**
     * @param string $status
     * @return OrderBuilderInterface
     */
    public function setStatus(string $status): OrderBuilderInterface
    {
        $this->order->status = $status;
        return $this;
    }

    /**
     * @param string $token
     * @return OrderBuilderInterface
     */
    public function setToken(string $token): OrderBuilderInterface
    {
        $this->order->token = $token;
        return $this;
    }

    /**
     * @param \DateTimeImmutable|null $verifiedAt
     * @return OrderBuilderInterface
     */
    public function setVerifiedAt(?\DateTimeImmutable $verifiedAt): OrderBuilderInterface
    {
        $this->order->verifiedAt = $verifiedAt;
        return $this;
    }

    /**
     * @param string|null $externalID
     * @return OrderBuilderInterface
     */
    public function setExternalID(?string $externalID): OrderBuilderInterface
    {
        $this->order->externalID = $externalID;
        return $this;
    }

    /**
     * @param int $amount
     * @return OrderBuilderInterface
     */
    public function setAmount(int $amount): OrderBuilderInterface
    {
        $this->order->amount = $amount;
        return $this;
    }

    /**
     * @param string $action
     * @return OrderBuilderInterface
     */
    public function setAction(string $action): OrderBuilderInterface
    {
        $this->order->action = $action;
        return $this;
    }


    private function setUrlReturn(): void
    {
        $urlGenerator = new OrderUrlGenerator();
        $this->order->urlReturn = $urlGenerator->generateReturnURL($this->order->uuid);
    }

    /**
     * @return void
     */
    private function setUrlWebhook(): void
    {
        $urlGenerator = new OrderUrlGenerator();
        $this->order->urlWebhook = $urlGenerator->generateWebhookURL($this->order->uuid);
    }

    public function getOrder(): Order
    {
        return $this->order;
    }
}