<?php

namespace App\Entity\Images\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Units\UnitID;

interface ImagesQueryInterface
{
    /**
     * @param UnitID $unitID
     * @param PaginationRequest $paginationRequest
     * @param bool $isOffset
     * @return GalleryDTO[]
     */
    public function findGalleryPhotosByUnitId(UnitID $unitID, PaginationRequest $paginationRequest, bool $isOffset): array;
}