<?php

namespace App\Entity\HearthAdoption;

use App\Entity\Contents\Content;
use App\Entity\Purposes\PurposeID;
use App\Models\HearthAdoption\UpdateHearthAdoptionModel;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Uid\Uuid;

/**
 * @ORM\Entity()
 */
class HearthAdoption
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private HearthAdoptionID|Uuid $uuid;

    /**
     * @ORM\OneToOne(targetEntity=Content::class, cascade={"persist"})
     * @ORM\JoinColumn(name="content_id", referencedColumnName="uuid", nullable=false)
     */
    private Content $content;

    /**
     * @ORM\Column(type="integer")
     */
    private int $children;

    /**
     * @ORM\Column(type="integer")
     */
    private int $monthlyCost;

    /**
     * @ORM\Column(type="datetime_immutable", nullable=true)
     */
    private ?\DateTimeImmutable $modifiedAt;

    public function __construct(Content $content, int $children, int $monthlyCost)
    {
        $this->uuid = HearthAdoptionID::generate();
        $this->content = $content;
        $this->children = $children;
        $this->monthlyCost = $monthlyCost;
    }

    /**
     * @return PurposeID|Uuid
     */
    public function getUuid(): PurposeID|Uuid
    {
        return $this->uuid;
    }

    /**
     * @return Content
     */
    public function getContent(): Content
    {
        return $this->content;
    }

    /**
     * @return int
     */
    public function getChildren(): int
    {
        return $this->children;
    }

    /**
     * @param int $children
     */
    public function updateChildren(int $children): void
    {
        $this->children = $children;
    }

    /**
     * @return int
     */
    public function getMonthlyCost(): int
    {
        return $this->monthlyCost;
    }

    /**
     * @param int $monthlyCost
     */
    public function updateMonthlyCost(int $monthlyCost): void
    {
        $this->monthlyCost = $monthlyCost;
    }

    /**
     * @return \DateTimeImmutable|null
     */
    public function getModifiedAt(): ?\DateTimeImmutable
    {
        return $this->modifiedAt;
    }

    public function updateModifiedAt(): void
    {
        $this->modifiedAt = new \DateTimeImmutable();
    }

    public function update(int $children, int $monthlyCost, string $content): void
    {
        $this->children = $children;
        $this->monthlyCost = $monthlyCost;
        $this->content->updateContent($content);
    }
}