<?php

namespace App\Entity\BalanceOperations\Classes;

use App\Entity\BalanceOperations\BalanceOperation;
use App\Entity\BalanceOperations\BalanceOperationsInterface;
use App\Entity\BalanceOperations\Helper\Type;
use App\Entity\Orders\Order;
use App\Entity\Users\User;

class BalanceOperationsManger implements BalanceOperationsManagerInterface
{

    public function __construct(public BalanceOperationsInterface $balanceOperations)
    {
    }

    public function createBalanceOperationFromOrder(Order $order): BalanceOperation
    {
        $balanceOperation = new BalanceOperation(
            $order->getVolunteer(),
            $order->getUnit()->getTitle(),
            $order->getBalanceOperationType(),
            $order
        );


        $balanceOperation->setAmountByPercentage($order->getAmount());

        $userBalance = $this->balanceOperations->getBalanceByUserID($order->getVolunteer(), $balanceOperation->getAmount());

        $balanceOperation->setBalance($userBalance);

        $this->balanceOperations->add($balanceOperation);

        return $balanceOperation;
    }

    public function createBalanceOperationByAdmin(User $volunteer, string $title, int $amount): BalanceOperation
    {
        $balanceOperation = new BalanceOperation(
            $volunteer,
            $title,
            Type::ADMIN_OPERATION
        );

        $userBalance = $this->balanceOperations->getBalanceByUserID($volunteer, $amount);

        $balanceOperation->setAmount($amount);
        $balanceOperation->setBalance($userBalance);

        $this->balanceOperations->add($balanceOperation);

        return $balanceOperation;
    }

}