<?php

namespace App\Entity\BalanceOperations\Classes;

use App\Entity\BalanceOperations\BalanceOperation;
use App\Entity\Orders\Order;
use App\Entity\Users\User;

interface BalanceOperationsManagerInterface
{
    /**
     * @param Order $order
     * @return BalanceOperation
     */
    public function createBalanceOperationFromOrder(Order $order): BalanceOperation;

    /**
     * @param User $volunteer
     * @param string $title
     * @param int $amount
     * @return BalanceOperation
     */
    public function createBalanceOperationByAdmin(User $volunteer, string $title, int $amount): BalanceOperation;
}