<?php

namespace App\Entity\Agreement\ReadModel;

use App\Entity\Agreement\Agreement;
use App\Entity\Agreement\AgreementID;

interface AgreementsInterface
{
    /**
     * @param AgreementID $agreementID
     * @return Agreement|null
     */
    public function findOneById(AgreementID $agreementID): ?Agreement;

    /**
     * @param array $agreementOriginalNames
     * @return array
     */
    public function findAgreementsToAssign(array $agreementOriginalNames): array;

    /**
     * @param array $agreementIDs
     * @return array
     */
    public function findAllByIDs(array $agreementIDs): array;
}