<?php

namespace App\Core\Voter;

use App\Entity\Permissions\Helper\PermissionChecker;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

class PublicAccessVoter extends Voter
{
    protected function supports(string $attribute, $subject): bool
    {
        return $this->canUsePublicAccess($attribute);
    }

    protected function voteOnAttribute(string $attribute, $subject, TokenInterface $token): bool
    {
        return true;
    }

    private function canUsePublicAccess(string $attribute): bool
    {
        return PermissionChecker::isPublic($attribute);
    }
}