<?php

namespace App\Core\Utils;

class Money
{
    private const MINOR = 100;

    /**
     * @param float $currency
     * @return int
     */
    public static function toMinor(float $currency): int
    {
        return (round($currency, 2)) * self::MINOR;
    }

    /**
     * @param int $minorCurrency
     * @return float
     */
    public static function toRational(int $minorCurrency): float
    {
        return $minorCurrency / self::MINOR;
    }
}