<?php

namespace App\Core\UrlGenerator\Reports;

use App\Core\UrlGenerator\CustomUrlGenerator;
use App\Entity\Posts\PostID;
use App\Entity\Units\UnitID;

class ReportUrlGenerator extends CustomUrlGenerator implements ReportUrlGeneratorInterface
{
    public function generatePostURL(UnitID $unitID, PostID $postID): string
    {
        return sprintf($this->frontendUrl . '/unit/%s/posts/%s', (string)$unitID, (string)$postID);
    }
}