<?php

namespace App\Core\UrlGenerator\Orders;

use App\Core\UrlGenerator\CustomUrlGenerator;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class OrderUrlGenerator extends CustomUrlGenerator implements OrderUrlGeneratorInterface
{


    /**
     * @param array $params
     * @return string
     */
    public function generateReturnURL(array $params): string
    {
//        return $this->urlGenerator->generate('', $params, UrlGeneratorInterface::ABSOLUTE_URL);
        return sprintf($this->frontendUrl . '/payment-status/%s', (string)$params['orderID']);
    }

    /**
     * @param array $params
     * @return string
     */
    public function generateWebhookURL(array $params): string
    {
        return $this->schema . $this->urlGenerator->generate('orders_webhook', $params, UrlGeneratorInterface::NETWORK_PATH);
    }

    /**
     * @param array $params
     * @return string
     */
    public function generateCardInfoURL(array $params): string
    {
        return $this->schema . $this->urlGenerator->generate('orders_card_info', $params, UrlGeneratorInterface::NETWORK_PATH);
    }

    public function generateRenewSubscriptionWebhookURL(array $params): string
    {
        return $this->schema .$this->urlGenerator->generate('orders_renew_subscription_webhook', $params, UrlGeneratorInterface::NETWORK_PATH);
    }

}