<?php

namespace App\Core\Transactions;

use App\Core\Exception\ApiException;
use Doctrine\ORM\EntityManagerInterface;

final class Transaction implements TransactionInterface
{

    public function __construct(
        private EntityManagerInterface $entityManager
    )
    {
    }

    public function begin()
    {
        $this->entityManager->beginTransaction();
    }

    public function commit()
    {
        $this->entityManager->flush();
        $this->entityManager->commit();
    }

    public function rollback()
    {
        $this->entityManager->rollback();
    }

    public function end()
    {
        //test example
        try {
            $this->commit();
        } catch (\Throwable $e) {
            $this->rollback();
            throw new ApiException($e->getMessage());
        }
    }
}