<?php

namespace App\Core\ParamConverter;

use App\Core\ValidatorModel\ValidatorModelInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\ParamConverterInterface;
use Symfony\Component\HttpFoundation\Request;

final class FormDataDeserializeParamConverter extends AbstractParamConverter implements ParamConverterInterface
{
    private const SUPPORT_INTERFACE = FormDataModelConverter::class;

    public function __construct(
        private ValidatorModelInterface $validatorModel
    ) {}

    public function apply(Request $request, ParamConverter $configuration): void
    {
        $classNamespace = $configuration->getClass();

        /** @var FormDataModelConverter $modelClass */
        $modelClass = new $classNamespace();
        $this->setValuesOnObject($modelClass, $request->request->all());
        $this->setValuesOnObject($modelClass, $request->files->all());

        $groups = array_merge(['Default'], $configuration->getOptions()['groups'] ?? []);
        $this->validatorModel->validate(value: $modelClass, groups: $groups);

        $request->attributes->set($configuration->getName(), $modelClass);
    }

    public function supports(ParamConverter $configuration): bool
    {
        return $configuration->getClass() && self::hasAccess($configuration->getClass(), self::SUPPORT_INTERFACE);
    }

    private function setValuesOnObject(FormDataModelConverter &$modelClass, array $parameters): void
    {
        foreach ($parameters as $parameterName => $parameterValue) {
            $setterName = 'set' . ucfirst($parameterName);
            $modelClass->$setterName($parameterValue);
        }
    }
}