<?php

namespace App\Core\Paginator\ObjectValue;

class PaginationResults implements \JsonSerializable
{
    private array $paginationData = [
        'data' => []
    ];

    public function data(array $paginationData): self
    {
        $this->paginationData['data'] = $paginationData;
        return $this;
    }

    public function totalRow(): self
    {
        $firstElement = current($this->paginationData['data']);
        $this->paginationData['totalRow'] = $firstElement ? $firstElement->totalRow() : 0;
        return $this;
    }

    public function jsonSerialize(): array
    {
        return $this->paginationData;
    }
}