<?php

namespace App\Core\File\FileToUpload;

use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;

class StatementToUpload implements FileToUploadInterface
{
    private const STATEMENT_MAX_SIZE = '3M';
    private const STATEMENT_MIME_TYPES = ['text/csv'];

    #[Assert\Image(
        maxSize: self::STATEMENT_MAX_SIZE,
        mimeTypes: self::STATEMENT_MIME_TYPES,
        groups: ['Default']
    )]
    private UploadedFile $uploadedFile;
    private string $uniqueStatementName;

    public function __construct(UploadedFile $uploadedFile)
    {
        $this->uploadedFile = $uploadedFile;
        $this->uniqueStatementName = uniqid() . '-' . $this->uploadedFile->getClientOriginalName();
    }

    public function getUniqueName(): string
    {
        return $this->uniqueStatementName;
    }

    public function getContent(): string
    {
        return $this->uploadedFile->getContent();
    }
}