<?php

declare(strict_types=1);

namespace App\Core\Exception;

use Symfony\Component\Validator\ConstraintViolationListInterface;

class ApiException extends \Exception
{
    private ConstraintViolationListInterface $errors;

    public static function fromErrors(ConstraintViolationListInterface $errors): ApiException
    {
        $apiException = new ApiException('Validation error', 406);
        $apiException->setErrors($errors);
        return $apiException;
    }

    public function __construct($message, $code = 0, \Exception $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public function getErrors(): ConstraintViolationListInterface
    {
        return $this->errors;
    }

    public function setErrors(ConstraintViolationListInterface $errors): void
    {
        $this->errors = $errors;
    }


}