<?php

namespace App\Core\EventListener;

use App\Core\Exception\ApiException;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\Exception\BadCredentialsException;
use Symfony\Component\Security\Http\Authentication\AuthenticationFailureHandlerInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class AuthenticationFailureListener implements AuthenticationFailureHandlerInterface
{
    public function __construct(
        private TranslatorInterface $translator
    ) {}

    /**
     * @throws ApiException
     */
    public function onAuthenticationFailure(Request $request, AuthenticationException $exception): void
    {
        if ($exception instanceof BadCredentialsException) {
            throw new ApiException(
                $this->translator->trans('login.invalid_credentials'),
                Response::HTTP_CONFLICT
            );
        }

        throw new ApiException(
            $exception->getMessage(),
            $exception->getCode()
        );
    }
}