<?php

namespace App\Controller\Users\Update;

use App\Entity\Permissions\Permission;
use App\Entity\Users\User;
use App\Services\Users\UpdateUserStatus;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Users")
 */
#[Route('/api/users', name: 'users_')]
class UpdateUserStatusController extends AbstractController
{
    public function __construct(
        private UpdateUserStatus $userStatus
    ) {}

    /**
     * @OA\Put(summary="Block user")
     */
    #[IsGranted(Permission::USERS_ADMINISTRATION)]
    #[Route(path: '/{userId}/block', name: 'block_status', methods: ['PUT'])]
    #[ParamConverter('user', options: ['mapping' => ['userId' => 'uuid']])]
    public function block(User $user): JsonResponse
    {
        $this->userStatus->block($user);
        return $this->json('User status has been updated');
    }

    /**
     * @OA\Put(summary="Unblock user")
     */
    #[IsGranted(Permission::USERS_ADMINISTRATION)]
    #[Route(path: '/{userId}/unblock', name: 'unblock_status', methods: ['PUT'])]
    #[ParamConverter('user', options: ['mapping' => ['userId' => 'uuid']])]
    public function unblock(User $user): JsonResponse
    {
        $this->userStatus->unblock($user);
        return $this->json('User status has been updated');
    }
}