<?php

namespace App\Controller\Users\Update;

use App\Entity\Permissions\Permission;
use App\Entity\Users\User;
use App\Models\Users\UserUnitAssignModel;
use App\Services\Users\UpdateUnitAssign;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use Nelmio\ApiDocBundle\Annotation\Model;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Units")
 */
#[Route(path: '/api/users', name: 'users_')]
class UpdateUserAssignedUnitsController extends AbstractController
{
    public function __construct(
        private UpdateUnitAssign $updateUnitAssign,
    ) {}

    /**
     * @OA\Put(summary="Assign unit")
     * @OA\RequestBody(
     *      @Model(type=UserAgreementsModel::class),
     *     description="Array must contain the checked agreementId"
     * )
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/{userId}/assign-units', name: 'assign_units', methods: ['PUT'])]
    #[ParamConverter('user', options: ['mapping' => ['userId' => 'uuid']])]
    public function assignUnits(
        User $user,
        UserUnitAssignModel $unitAssignModel
    ): JsonResponse
    {
        $this->updateUnitAssign->update($user, $unitAssignModel);

        return $this->json('Assign units has been updated');
    }
}