<?php

namespace App\Controller\Users\Data;

use App\Entity\Permissions\Permission;
use App\Entity\Units\ReadModel\UnitsQueryInterface;
use App\Entity\Units\UnitID;
use App\Entity\Users\ReadModel\UsersQueryInterface;
use App\Entity\Users\User;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Users")
 */
#[Route('/api/users', name: 'users_')]
class UserAssignedUnitsController extends AbstractController
{
    public function __construct(
        private UnitsQueryInterface $unitsQuery,
    )
    {
    }

    /**
     * @OA\Get(summary="Show user assigned units")
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/{userId}/units-to-assign', name: 'show_user_units_to_assign', methods: ['GET'])]
    #[ParamConverter('user', options: ['mapping' => ['userId' => 'uuid']])]
    public function showUserUnitsToAssign(User $user): JsonResponse
    {
        return $this->json(
            $this->unitsQuery->findAllUserUnitsToAssign($user->getUuid())
        );
    }
}