<?php

namespace App\Controller\Users\Data;

use App\Entity\Permissions\Permission;
use App\Entity\Users\ReadModel\PersonalDataDTO;
use App\Entity\Users\User;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Users")
 */
#[Route('/api')]
class LoggedUserController extends AbstractController
{
    /** @OA\Get(summary="Show logged user data") */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route(path: '/logged', name: 'logged', methods: ['GET'])]
    public function logged()
    {
        /** @var User $user */
        $user = $this->getUser();
        return $this->json(data: $user ? PersonalDataDTO::fromUser($user) : null);
    }
}