<?php

namespace App\Controller\Units\Create;

use App\Entity\Permissions\Permission;
use App\Entity\Units\Unit;
use App\Models\Posts\PostModel;
use App\Services\Posts\CreatePost;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use OpenApi\Annotations as OA;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Units")
 */
#[Route(path: '/api/units', name: 'units_')]
class CreateUnitPostController extends AbstractController
{
    public function __construct(
        private CreatePost $createPost
    ) {}

    /**
     * @OA\Post(summary="Create new post")
     * @OA\RequestBody(
     *     @OA\MediaType(
     *          mediaType="multipart/form-data",
     *          @OA\Schema(
     *              type="object",
     *              required={"title", "description", "content"},
     *              @OA\Property(property="title", type="string"),
     *              @OA\Property(property="description", type="string"),
     *              @OA\Property(property="content", type="string"),
     *              @OA\Property(property="photo", type="file")
     *          )
     *     )
     * )
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{unitId}/post', name: 'create_post', methods: ['POST'])]
    #[ParamConverter('unit', options: ['mapping' => ['unitId' => 'uuid']])]
    public function create(Unit $unit, PostModel $postModel): JsonResponse
    {
        $postId = $this->createPost->create($postModel, $unit);
        return $this->json($postId);
    }
}