<?php

namespace App\Controller\SliderImages;

use App\Entity\Permissions\Permission;
use App\Entity\SliderImages\SliderImage;
use App\Services\Sliders\DeletePhoto;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Slider Images")
 */
#[Route(path: '/api', name: 'slider_images_')]
class DeleteSliderImageController extends AbstractController
{
    public function __construct(
        private DeletePhoto $deletePhoto
    ) {}

    /**
     * @OA\Delete(summary="Delete slider image")
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/slider-image/{sliderImageId}', name: 'slider_image_delete', methods: ['DELETE'])]
    #[ParamConverter('sliderImage', options: ['mapping' => ['sliderImageId' => 'uuid']])]
    public function delete(SliderImage $sliderImage): JsonResponse
    {
        $this->deletePhoto->delete($sliderImage);
        return $this->json('Photo have been deleted');
    }
}