<?php

namespace App\Controller\Roles;

use App\Entity\Permissions\Permission;
use App\Entity\Roles\ReadModel\RolesQueryInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use OpenApi\Annotations as OA;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Roles")
 */
#[Route(path: '/api/roles', name: 'roles_')]
class RoleDataController extends AbstractController
{
    public function __construct(
        private RolesQueryInterface $rolesQuery
    ) {}

    /**
     * @OA\Get(summary="Role list")
     */
    #[IsGranted(Permission::USERS_ADMINISTRATION)]
    #[Route(name: 'list', methods: ['GET'])]
    public function list(): JsonResponse
    {
        return $this->json(
            $this->rolesQuery->findAllRoles()
        );
    }
}