<?php

namespace App\Controller\Purposes;

use App\Entity\Permissions\Permission;
use App\Entity\Purposes\Purpose;
use App\Models\Purposes\UpdatePurposeModel;
use App\Services\Purposes\UpdatePurpose;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;
use Nelmio\ApiDocBundle\Annotation\Model;

/**
 * @OA\Tag(name="Purposes")
 */
#[Route(path: '/api/purposes', name: 'purposes_')]
class UpdatePurposeController extends AbstractController
{
    public function __construct(
        private UpdatePurpose $updatePurpose
    ) {}

    /**
     * @OA\Put(summary="Update purpose")
     * @OA\RequestBody(
     *     @Model(type=UpdatePurposeModel::class)
     * )
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{purposeId}', name: 'update', methods: ['PUT'])]
    #[ParamConverter('purpose', options: ['mapping' => ['purposeId' => 'uuid']])]
    public function updatePurpose(Purpose $purpose, UpdatePurposeModel $updatePurposeModel): JsonResponse
    {
        $this->updatePurpose->update($purpose, $updatePurposeModel);
        return $this->json('Purpose has been updated');
    }
}