<?php

namespace App\Controller\Purposes;

use App\Entity\Permissions\Permission;
use App\Entity\Purposes\PurposeID;
use App\Entity\Purposes\ReadModel\PurposesQueryInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Purposes")
 */
#[Route(path: '/api/purposes', name: 'purposes_')]
class PurposeDataController extends AbstractController
{
    public function __construct(
        private PurposesQueryInterface $purposesQuery
    ) {}

    /**
     * @OA\Get(summary="Show purpose")
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{purposeId}', name: 'show', methods: ['GET'])]
    public function show(string $purposeId): JsonResponse
    {
        return $this->json(
            $this->purposesQuery->findOnePurposeById(PurposeID::fromString($purposeId))
        );
    }
}