<?php

namespace App\Controller\Photos;

use App\Entity\Images\Image;
use App\Entity\Permissions\Permission;
use App\Models\Gallery\PhotoDetailsModel;
use App\Services\Galleries\UpdatePhoto;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;
use Nelmio\ApiDocBundle\Annotation\Model;

/**
 * @OA\Tag(name="Photos")
 */
#[Route(path: '/api', name: 'photo_')]
class UpdateGalleryPhotoController extends AbstractController
{
    public function __construct(
        private UpdatePhoto $updatePhoto
    ) {}

    /**
     * @OA\Put(summary="Update gallery photo")
     * @OA\RequestBody(
     *     @Model(type=PhotoDetailsModel::class)
     * )
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/photo/{photoId}', name: 'gallery_update', methods: ['PUT'])]
    #[ParamConverter('image', options: ['mapping' => ['photoId' => 'uuid']])]
    public function update(Image $image, PhotoDetailsModel $photoDetailsModel): JsonResponse
    {
        $this->updatePhoto->update($image, $photoDetailsModel);
        return $this->json('Photos have been updated');
    }
}