<?php

namespace App\Controller\Orders;

use App\Entity\Permissions\Permission;
use App\Entity\Subscriptions\ReadModel\SubscriptionsQueryInterface;
use App\Entity\Subscriptions\Subscription;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Orders")
 */
#[Route(path: '/api/subscriptions', name: 'subscriptions_')]
class SubscriptionDataController extends AbstractController
{
    public function __construct(
        private SubscriptionsQueryInterface $subscriptionsQuery
    )
    {
    }

    /**
     * @OA\Get(summary="Show subscription data")
     * @param Subscription $subscription
     * @return Response
     */
    #[IsGranted(Permission::PAYMENTS_MANAGEMENT)]
    #[Route('/{subscriptionID}', name: 'show', methods: ['GET'])]
    #[ParamConverter('subscription', options: ['mapping' => ['subscriptionID' => 'uuid']])]
    public function show(Subscription $subscription): Response
    {
        return $this->json($this->subscriptionsQuery->getOneBySubscriptionID($subscription->getUuid()));
    }
}