<?php

namespace App\Controller\Orders;

use App\Entity\Orders\Order;
use App\Entity\Orders\OrderID;
use App\Entity\Orders\OrdersInterface;
use App\Entity\Orders\ReadModel\OrdersQueryInterface;
use App\Entity\Permissions\Permission;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;

/**
 * @OA\Tag(name="Orders")
 */
#[Route(path: '/api/orders', name: 'orders_')]
class OrderDataController extends AbstractController
{
    public function __construct(
        private OrdersQueryInterface $ordersQuery
    )
    {
    }

    /**
     * @param string $orderId
     * @return Response
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route('/{orderId}', name: 'show', methods: ['GET'])]
    public function show(string $orderId): Response
    {
        return $this->json($this->ordersQuery->findOneByOrderID(OrderID::fromString($orderId)));
    }

    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route('', name: 'list', methods: ['GET'])]
    public function orders(OrdersInterface $orders): Response
    {
        return $this->json(
            data: $orders->findAll(),context: [AbstractNormalizer::ATTRIBUTES => ['uuid']]);
    }
}