<?php

namespace App\Adapter\Subscriptions\Email;

use App\Core\Exception\ApiException;
use App\Entity\Units\Helper\Type as UnitType;

class SubscriptionCardChargeNotificationTemplate
{
    private string $type;
    private static array $typesTemplates = [
        UnitType::INSTITUTION => [
            'subject' => 'Problem z pobraniem środków',
            'template' => 'email/institution_card_charge.html.twig'
        ],

        UnitType::FAMILY => [
            'subject' => 'Problem z pobraniem środków',
            'template' => 'email/family_card_charge.html.twig'
        ]
    ];

    public function __construct(
        UnitType $type
    )
    {
        $this->type = (string)$type;
    }

    /**
     * @return string
     * @throws ApiException
     */
    public function getTemplate(): string
    {
        if (isset(self::$typesTemplates[$this->type]['template'])) {
            return self::$typesTemplates[$this->type]['template'];
        }
        throw new ApiException('typeTemplate error');
    }

    public function getSubject(): string
    {
        if (isset(self::$typesTemplates[$this->type]['subject'])) {
            return self::$typesTemplates[$this->type]['subject'];
        }
        throw new ApiException('typeTemplate error');
    }
}