<?php

namespace App\Adapter\Sliders\ReadModel;

use App\Adapter\SliderImages\SliderImages;
use App\Entity\SliderImages\ReadModel\SliderImagesQueryInterface;
use App\Entity\Sliders\ReadModel\SliderDTO;
use App\Entity\Sliders\ReadModel\SliderQueryInterface;
use App\Entity\Sliders\SliderID;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Driver\Exception;
use Doctrine\DBAL\Exception as DBALException;

class SlidersQuery implements SliderQueryInterface
{
    public function __construct(
        private Connection $connection,
        private SliderImagesQueryInterface $sliderImagesQuery
    ) {}


    public function getSliderWithImages(): ?SliderDTO
    {
        $qb = $this->connection->createQueryBuilder();

        $query = $qb
            ->select('s.duration_time as durationTime')
            ->addSelect('s.uuid')
            ->from('slider', 's');

        $results = $query->execute()->fetch();

        $results['photos'] = $this->sliderImagesQuery->findSliderImagesBySliderId(SliderID::fromString($results['uuid']));

        return SliderDTO::fromArray($results);
    }

    public function getLastOrderNumber(): int
    {
        $qb = $this->connection->createQueryBuilder();

        $query = $qb
            ->select('MAX(sI.order_number)')
            ->from('slider', 's')
            ->leftJoin('s', 'slider_image', 'sI', 's.uuid = sI.slider_id')
            ->setMaxResults(1);

         return (int) $query->execute()->fetchOne();
    }
}