<?php

namespace App\Adapter\SliderImages;

use App\Entity\SliderImages\SliderImage;
use App\Entity\SliderImages\SliderImagesInterface;
use App\Entity\Sliders\SliderID;
use Doctrine\ORM\EntityManagerInterface;

class SliderImages implements SliderImagesInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {}

    public function add(SliderImage $sliderImage): void
    {
        $this->entityManager->persist($sliderImage);
    }

    public function remove(SliderImage $sliderImage): void
    {
        $this->entityManager->remove($sliderImage);
    }

    public function getSliderImagesWithOrderNumberBiggerThan(SliderID $sliderID, int $orderNumber): array
    {
        $qb = $this->entityManager->createQueryBuilder();

        return $qb
            ->select('sI')
            ->from(SliderImage::class, 'sI')
            ->leftJoin('sI.slider', 's',)
            ->where('sI.orderNumber > :orderNumber')
            ->andWhere('s.uuid = :sliderId')
            ->setParameter('orderNumber', $orderNumber)
            ->setParameter('sliderId', $sliderID,'uuid')
            ->getQuery()
            ->getResult();
    }

    public function findAllByIDs(array $sliderImageIDs): array
    {
        $qb = $this->entityManager->createQueryBuilder();

        return $qb
            ->select('sI')
            ->from(SliderImage::class, 'sI')
            ->where($qb->expr()->in('sI.uuid', ':sliderImageIDs'))
            ->setParameter('sliderImageIDs', array_map(fn($sliderImageID) => $sliderImageID->toBinary(), $sliderImageIDs))
            ->getQuery()
            ->execute();
    }
}