<?php

namespace App\Adapter\Images\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Core\Paginator\PaginatorInterface;
use App\Entity\Images\ReadModel\GalleryDTO;
use App\Entity\Images\ReadModel\ImagesQueryInterface;
use App\Entity\Units\UnitID;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Driver\Exception;
use Doctrine\DBAL\Exception as DBALException;

class ImagesQuery implements ImagesQueryInterface
{
    public function __construct(
        private Connection $connection,
        private PaginatorInterface $paginator
    ) {}

    /**
     * @throws Exception
     * @throws DBALException
     * @throws \ReflectionException
     */
    public function findGalleryPhotosByUnitId(UnitID $unitID, PaginationRequest $paginationRequest, bool $isOffset): array
    {
        $qb = $this->connection->createQueryBuilder();

        $query = $qb
            ->select('i.uuid as photoId')
            ->addSelect('i.image as photo')
            ->addSelect('i.title')
            ->from('image', 'i')
            ->where('i.unit_id = :unitId')
            ->setParameter('unitId', $unitID, 'uuid')
            ->orderBy('i.created_at', 'DESC');

        $this->paginator->addPagination($query, $paginationRequest, $isOffset);
        $results = $query->execute()->fetchAllAssociative();

        return array_map(fn($image) => GalleryDTO::fromArray($image), $results);
    }
}