<?php

namespace App\Adapter\Images;

use App\Entity\Images\Image;
use App\Entity\Images\ImageID;
use App\Entity\Images\ImagesInterface;
use App\Entity\Units\UnitID;
use Doctrine\ORM\EntityManagerInterface;

class Images implements ImagesInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {}

    public function add(Image $image): void
    {
        $this->entityManager->persist($image);
    }

    public function remove(Image $image): void
    {
        $this->entityManager->remove($image);
    }

    /**
     * @param ImageID $imageID
     * @param UnitID $unitID
     * @return Image
     */
    public function findPhotoToEdit(ImageID $imageID, UnitID $unitID): Image
    {
        return $this->entityManager
            ->getRepository(Image::class)
            ->findOneBy([
                'uuid' => $imageID,
                'unit' => $unitID
            ]);
    }

    public function findPhotosToDelete(array $imagesIDs, UnitID $unitID): array
    {
        $qb = $this->entityManager->createQueryBuilder();

        return $qb
            ->select('i')
            ->from(Image::class, 'i')
            ->where($qb->expr()->notIn('i.uuid', ':imagesIds'))
            ->andWhere('i.unit = :unitId')
            ->setParameter('imagesIds', $imagesIDs)
            ->setParameter('unitId', $unitID, 'uuid')
            ->getQuery()
            ->execute();
    }
}